/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar.local;

import com.sun.nio.file.ExtendedWatchEventModifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.minecraft.Util;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.UserData;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.parsers.AvatarMetadataParser;
import org.figuramc.figura.parsers.BlockbenchModelParser;
import org.figuramc.figura.parsers.LuaScriptParser;
import org.figuramc.figura.utils.FiguraResourceListener;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.IOUtils;

public class LocalAvatarLoader {
    public static final boolean IS_WINDOWS = Util.getPlatform() == Util.OS.WINDOWS;
    private static final HashMap<Path, WatchKey> KEYS = new HashMap();
    private static CompletableFuture<Void> tasks;
    private static Path lastLoadedPath;
    private static LoadState loadState;
    private static String loadError;
    private static WatchService watcher;
    public static final HashMap<ResourceLocation, CompoundTag> CEM_AVATARS;
    public static final FiguraResourceListener AVATAR_LISTENER;

    protected static void async(Runnable toRun) {
        if (tasks == null || tasks.isDone()) {
            tasks = CompletableFuture.runAsync(toRun);
        } else {
            tasks.thenRun(toRun);
        }
    }

    public static void loadAvatar(Path path, UserData target) {
        loadError = null;
        loadState = LoadState.UNKNOWN;
        LocalAvatarLoader.resetWatchKeys();
        try {
            path = path == null ? null : (path.getFileSystem() == FileSystems.getDefault() ? Path.of(path.toFile().getCanonicalPath(), new String[0]) : path.normalize());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        lastLoadedPath = path;
        if (path == null || target == null) {
            return;
        }
        LocalAvatarLoader.addWatchKey(path, KEYS::put);
        Path finalPath = path;
        LocalAvatarLoader.async(() -> {
            try {
                CompoundTag metadataTag;
                CompoundTag nbt = new CompoundTag();
                loadState = LoadState.SCRIPTS;
                LocalAvatarLoader.loadScripts(finalPath, nbt);
                loadState = LoadState.SOUNDS;
                LocalAvatarLoader.loadSounds(finalPath, nbt);
                CompoundTag textures = new CompoundTag();
                ListTag animations = new ListTag();
                BlockbenchModelParser modelParser = new BlockbenchModelParser();
                loadState = LoadState.MODELS;
                CompoundTag models = LocalAvatarLoader.loadModels(finalPath, finalPath, modelParser, textures, animations, "");
                models.putString("name", "models");
                loadState = LoadState.METADATA;
                String _meta = IOUtils.readFile(finalPath.resolve("avatar.json"));
                AvatarMetadataParser.Metadata metadata = AvatarMetadataParser.read(_meta);
                CompoundTag metaNBT = AvatarMetadataParser.parse(metadata, _meta, IOUtils.getFileNameOrEmpty(finalPath));
                nbt.put("metadata", (Tag)metaNBT);
                metaNBT.putString("uuid", target.id.toString());
                AvatarMetadataParser.injectToModels(metadata, models);
                AvatarMetadataParser.injectToTextures(metadata, textures);
                if (!models.isEmpty()) {
                    nbt.put("models", (Tag)models);
                }
                if (!textures.isEmpty()) {
                    nbt.put("textures", (Tag)textures);
                }
                if (!animations.isEmpty()) {
                    nbt.put("animations", (Tag)animations);
                }
                if ((metadataTag = nbt.getCompound("metadata")).contains("resources_paths")) {
                    LocalAvatarLoader.loadResources(nbt, metadataTag.getList("resources_paths", 8), finalPath);
                    metadataTag.remove("resource_paths");
                }
                target.loadAvatar(nbt);
            }
            catch (Throwable e) {
                loadError = e.getMessage();
                FiguraMod.LOGGER.error("Failed to load avatar from " + String.valueOf(finalPath), e);
                FiguraToast.sendToast(FiguraText.of("toast.load_error"), FiguraText.of("gui.load_error." + LocalAvatarLoader.getLoadState()), FiguraToast.ToastType.ERROR);
            }
        });
    }

    private static void loadResources(CompoundTag nbt, ListTag pathsTag, Path parentPath) {
        ArrayList<PathMatcher> pathMatchers = new ArrayList<PathMatcher>();
        FileSystem fs = FileSystems.getDefault();
        for (int i = 0; i < pathsTag.size(); ++i) {
            pathMatchers.add(fs.getPathMatcher("glob:".concat(pathsTag.getString(i))));
        }
        HashMap<String, Path> pathMap = new HashMap<String, Path>();
        LocalAvatarLoader.matchPathsRecursive(pathMap, parentPath, parentPath, pathMatchers);
        CompoundTag resourcesTag = new CompoundTag();
        for (String p : pathMap.keySet()) {
            try (FileInputStream fis = new FileInputStream(((Path)pathMap.get(p)).toFile());){
                int i;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                while ((i = fis.read()) != -1) {
                    gos.write(i);
                }
                gos.close();
                resourcesTag.put(LocalAvatarLoader.unixifyPath(p), (Tag)new ByteArrayTag(baos.toByteArray()));
                baos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        nbt.put("resources", (Tag)resourcesTag);
    }

    private static String unixifyPath(String original) {
        Path p = Path.of(original, new String[0]);
        CharSequence[] components = new String[p.getNameCount()];
        for (int i = 0; i < components.length; ++i) {
            components[i] = p.getName(i).toString();
        }
        return String.join((CharSequence)"/", components);
    }

    private static void matchPathsRecursive(Map<String, Path> pathMap, Path parent, Path current, ArrayList<PathMatcher> matchers) {
        File f = current.toFile();
        if (f.isFile()) {
            Path relative = parent.toAbsolutePath().relativize(current.toAbsolutePath()).normalize();
            for (PathMatcher m : matchers) {
                if (!m.matches(relative)) continue;
                pathMap.put(relative.toString(), current);
                break;
            }
        } else {
            for (File fl : current.toFile().listFiles()) {
                LocalAvatarLoader.matchPathsRecursive(pathMap, parent, fl.toPath(), matchers);
            }
        }
    }

    private static void loadScripts(Path path, CompoundTag nbt) throws IOException {
        List<Path> scripts = IOUtils.getFilesByExtension(path, ".lua");
        if (scripts.size() > 0) {
            CompoundTag scriptsNbt = new CompoundTag();
            String pathRegex = path.toString().isEmpty() ? "\\Q\\E" : Pattern.quote(String.valueOf(path) + path.getFileSystem().getSeparator());
            for (Path script : scripts) {
                String name = script.toString().replaceFirst(pathRegex, "").replaceAll("[/\\\\]", ".");
                name = name.substring(0, name.length() - 4);
                scriptsNbt.put(name, (Tag)LuaScriptParser.parseScript(name, IOUtils.readFile(script)));
            }
            nbt.put("scripts", (Tag)scriptsNbt);
        }
    }

    private static void loadSounds(Path path, CompoundTag nbt) throws IOException {
        List<Path> sounds = IOUtils.getFilesByExtension(path, ".ogg");
        if (sounds.size() > 0) {
            CompoundTag soundsNbt = new CompoundTag();
            String pathRegex = Pattern.quote((String)(path.toString().isEmpty() ? path.toString() : String.valueOf(path) + path.getFileSystem().getSeparator()));
            for (Path sound : sounds) {
                String name = sound.toString().replaceFirst(pathRegex, "").replaceAll("[/\\\\]", ".");
                name = name.substring(0, name.length() - 4);
                soundsNbt.putByteArray(name, IOUtils.readFileBytes(sound));
            }
            nbt.put("sounds", (Tag)soundsNbt);
        }
    }

    private static CompoundTag loadModels(Path avatarFolder, Path currentFile, BlockbenchModelParser parser, CompoundTag textures, ListTag animations, String folders) throws Exception {
        CompoundTag result = new CompoundTag();
        List<Path> subFiles = IOUtils.listPaths(currentFile);
        ListTag children = new ListTag();
        if (subFiles != null) {
            for (Path file : subFiles) {
                if (IOUtils.isHidden(file)) continue;
                String name = IOUtils.getFileNameOrEmpty(file);
                if (Files.isDirectory(file, new LinkOption[0])) {
                    CompoundTag subfolder = LocalAvatarLoader.loadModels(avatarFolder, file, parser, textures, animations, folders + name + ".");
                    if (subfolder.isEmpty()) continue;
                    subfolder.putString("name", name);
                    BlockbenchModelParser.parseParent(name, subfolder);
                    children.add((Object)subfolder);
                    continue;
                }
                if (!file.toString().toLowerCase(Locale.US).endsWith(".bbmodel")) continue;
                BlockbenchModelParser.ModelData data = parser.parseModel(avatarFolder, file, IOUtils.readFile(file), name.substring(0, name.length() - 8), folders);
                children.add((Object)data.modelNbt());
                animations.addAll(data.animationList());
                CompoundTag dataTag = data.textures();
                if (dataTag.isEmpty()) continue;
                if (textures.isEmpty()) {
                    textures.put("data", (Tag)new ListTag());
                    textures.put("src", (Tag)new CompoundTag());
                }
                textures.getList("data", 10).addAll((Collection)dataTag.getList("data", 10));
                textures.getCompound("src").merge(dataTag.getCompound("src"));
            }
        }
        if (children.size() > 0) {
            result.put("chld", (Tag)children);
        }
        return result;
    }

    public static void tick() {
        WatchEvent<?> event = null;
        boolean reload = false;
        for (Map.Entry<Path, WatchKey> entry : KEYS.entrySet()) {
            WatchKey key = entry.getValue();
            if (!key.isValid()) continue;
            for (WatchEvent<?> watchEvent : key.pollEvents()) {
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                event = watchEvent;
                Path path = entry.getKey().resolve((Path)event.context());
                String name = IOUtils.getFileNameOrEmpty(path);
                if (IOUtils.isHiddenAvatarResource(path) || !Files.isDirectory(path, new LinkOption[0]) && !name.matches("(.*(\\.lua|\\.bbmodel|\\.ogg|\\.png)$|avatar\\.json)")) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE && !IS_WINDOWS) {
                    LocalAvatarLoader.addWatchKey(path, KEYS::put);
                }
                reload = true;
                break;
            }
            if (!reload) continue;
            break;
        }
        if (reload) {
            FiguraMod.debug("Detected file changes in the Avatar directory (" + event.context().toString() + "), reloading!", new Object[0]);
            AvatarManager.loadLocalAvatar(lastLoadedPath);
        }
    }

    public static void resetWatchKeys() {
        lastLoadedPath = null;
        for (WatchKey key : KEYS.values()) {
            key.cancel();
        }
        KEYS.clear();
    }

    protected static void addWatchKey(Path path, BiConsumer<Path, WatchKey> consumer) {
        if (watcher == null || path == null || path.getFileSystem() != FileSystems.getDefault()) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0]) || IOUtils.isHidden(path)) {
            return;
        }
        try {
            WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
            WatchKey key = IS_WINDOWS ? path.register(watcher, events, ExtendedWatchEventModifier.FILE_TREE) : path.register(watcher, events);
            consumer.accept(path, key);
            List<Path> children = IOUtils.listPaths(path);
            if (children == null || IS_WINDOWS) {
                return;
            }
            for (Path child : children) {
                LocalAvatarLoader.addWatchKey(child, consumer);
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to register watcher for " + String.valueOf(path), (Throwable)e);
        }
    }

    public static Path getLastLoadedPath() {
        return lastLoadedPath;
    }

    public static String getLoadState() {
        return loadState.name().toLowerCase(Locale.US);
    }

    public static String getLoadError() {
        return loadError;
    }

    static {
        loadState = LoadState.UNKNOWN;
        CEM_AVATARS = new HashMap();
        AVATAR_LISTENER = FiguraResourceListener.createResourceListener("cem", manager -> {
            CEM_AVATARS.clear();
            AvatarManager.clearCEMAvatars();
            for (Map.Entry cem : manager.listResources("cem", location -> location.getNamespace().equals("figura") && location.getPath().endsWith(".nbt")).entrySet()) {
                CompoundTag nbt;
                ResourceLocation key = (ResourceLocation)cem.getKey();
                String[] split = key.getPath().split("/");
                if (split.length <= 1) continue;
                String namespace = split[split.length - 2];
                String path = split[split.length - 1];
                ResourceLocation id = new ResourceLocation(namespace, path.substring(0, path.length() - 4));
                try {
                    nbt = NbtIo.readCompressed((InputStream)((Resource)cem.getValue()).open(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("Failed to load " + String.valueOf(id) + " avatar", (Throwable)e);
                    continue;
                }
                FiguraMod.LOGGER.info("Loaded CEM model for " + String.valueOf(id));
                CEM_AVATARS.put(id, nbt);
            }
        });
        try {
            watcher = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to initialize the watcher service", (Throwable)e);
        }
    }

    private static enum LoadState {
        UNKNOWN,
        SCRIPTS,
        SOUNDS,
        MODELS,
        METADATA;

    }
}

